package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * The Class RequestHistory.
 * 
 * Description: In this RequestHistory Class implements the interface
 * Serializable and defines the entity and data mapping for the
 * dbo.User_Approver Table in the database.
 */
@Entity
@Table(name = "RequestHistory", schema = "dbo")
public class RequestHistory implements Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -3025948940261885259L;
	
	@Id
	@Column(name = "HistLineNo", unique = true, nullable = false)
	private int histLineNo;

	@Column(name = "id", nullable = false, insertable = false, updatable = false)
	private int requestId;
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "Id", nullable = false)
	private Request request;
	
	@Column(name = "ProcessId", nullable = false)
	private int processId;
	
	@Column(name = "Title", length = 256)
	private String title;
	
	@Column(name = "Description", length = 3000)
	private String description;
	
	@Column(name = "StatusDescription", length = 50)
	private String statusDescription;
	
	@Column(name = "RequestTypeId", nullable = false)
	private int requestTypeId;
	
	@Column(name = "SourceId", nullable = false)
	private int sourceId;
	
	@Column(name = "StudyApprovalId", nullable = false)
	private int studyApprovalId;
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	private Date createdOn;
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "ModifiedOn", length = 23)
	private Date modifiedOn;
	
	@Column(name = "CreatedBy", length = 50)
	private String createdBy;
	
	@Column(name = "ModifiedBy", length = 50)
	private String modifiedBy;
	
	@Column(name = "ApproverId", length = 50)
	private String approverId;
	
	@Column(name = "TaskId", length = 50)
	private String taskId;
	

	public int getHistLineNo() {
		return this.histLineNo;
	}

	public void setHistLineNo(int histLineNo) {
		this.histLineNo = histLineNo;
	}
	
	public int getRequestId() {
		return requestId;
	}
	
	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}

	public Request getRequest() {
		return this.request;
	}

	public void setRequest(Request request) {
		this.request = request;
	}

	public int getProcessId() {
		return this.processId;
	}

	public void setProcessId(int processId) {
		this.processId = processId;
	}

	public String getTitle() {
		return this.title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getStatusDescription() {
		return this.statusDescription;
	}

	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	public int getRequestTypeId() {
		return this.requestTypeId;
	}

	public void setRequestTypeId(int requestTypeId) {
		this.requestTypeId = requestTypeId;
	}

	public int getSourceId() {
		return this.sourceId;
	}

	public void setSourceId(int sourceId) {
		this.sourceId = sourceId;
	}

	public int getStudyApprovalId() {
		return this.studyApprovalId;
	}

	public void setStudyApprovalId(int studyApprovalId) {
		this.studyApprovalId = studyApprovalId;
	}

	public Date getCreatedOn() {
		return this.createdOn;
	}

	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	public Date getModifiedOn() {
		return this.modifiedOn;
	}

	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	public String getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public String getModifiedBy() {
		return this.modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	public String getApproverId() {
		return this.approverId;
	}

	public void setApproverId(String approverId) {
		this.approverId = approverId;
	}

	public String getTaskId() {
		return this.taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}
}
